
from utils import *
from aardvark_py import *
from config import *
import config
import time

handle = int()

#==============================================================================
# write_byte_FXOS8700CQ_chk
#==============================================================================
# one byte write with error checking

def write_byte_FXOS8700CQ_chk( addr_plus_data ):

	byteIn = 0
	count = 0
	
	if config.INTERFACE == I2C:

		aa_i2c_write(handle, SLAVE_ADDR, AA_I2C_NO_FLAGS, \
			array( 'B', addr_plus_data ) )

		#time.sleep(.05)

		aa_i2c_write(handle, SLAVE_ADDR, AA_I2C_NO_STOP, \
			array( 'B', [addr_plus_data[0]] ) )

		#time.sleep(.05)

		(count, dataIn) = aa_i2c_read(handle, SLAVE_ADDR, AA_I2C_NO_FLAGS, 1)

		byteIn = dataIn[0]

	elif config.INTERFACE == SPI:

		dataOut = [0]
		dataIn = tmp = [0] * 3 
		count = 1
		
		dataOut = prep_spi_addr( 1, addr_plus_data[0], dataOut )

		# actual data goes following dataOut[1]
		
		dataOut[2] = addr_plus_data[1]

		# send out 3 bytes, receive nothing

		(count, dataIn) = aa_spi_write( handle, array( 'B', dataOut) , array( 'B', tmp ) )

        #print "SPI write out => ", dataOut
        #print "SPI read back => ", dataIn

		# now read back to verify
		
		dataOut[0] = dataOut[0] & 0x7F # mask R/W bit, making it R
		
		(count, dataIn) = aa_spi_write( handle, array( 'B', dataOut ) , array( 'B', tmp ) )
		
        #print "SPI write out => ", dataOut
        #print "SPI read back => ", dataIn

		byteIn = dataIn[2]
	
	else:

		print "You must select a comm interface!!"
		print "in config, var interface"
		sys.exit()

	#print "%d byte read back for comparison" % count
	#print "dataIn => ", dataIn
	#print "handle = %d" % handle

	if addr_plus_data[1] != byteIn:

		print "Error writing to FXOS8700CQ!!!"
		print "Exiting..."
		sys.exit()

	#time.sleep(1)

#==============================================================================
# read_FXOS8700CQ
#==============================================================================
# read single or multiple bytes  

def read_FXOS8700CQ( start_addr, len ):

	count = 0
	
	if config.INTERFACE == I2C:

		aa_i2c_write(handle, SLAVE_ADDR, AA_I2C_NO_STOP, \
				array('B', [start_addr] ))
		(count, dataIn) = aa_i2c_read(handle, SLAVE_ADDR, AA_I2C_NO_FLAGS, len)

	elif config.INTERFACE == SPI:

		dataIn = [0] * (len+2)
		dataOut = [0] * len

		dataOut = prep_spi_addr( 0, start_addr, dataOut )
				
		(count, dataIn) = aa_spi_write( handle, array( 'B', dataOut ), array( 'B', dataIn) )

		count = count - 2

		dataIn = dataIn[2:]		

	else:

		print "You must select a comm interface!!"
		print "in config, var interface"
		sys.exit()
	

	#print "%d bytes read " % count
	
	#for i in range(count):
	#    print "data[%d] = 0x%d" % (i, data_in[i])
	
	#print ""

	return (count, dataIn)

#==============================================================================
# write_FXOS8700CQ
#==============================================================================
# write multiple bytes starting from startAddr

def write_FXOS8700CQ( startAddr, toWrite ):

    #print "write_FXOS8700CQ"
	
	if config.INTERFACE == I2C:

        #print "I2C mode"

		toWrite.insert(0, startAddr)

        #print "IIC write => ", toWrite

		aa_i2c_write(handle, SLAVE_ADDR, AA_I2C_NO_FLAGS, array( 'B', toWrite ) )

	
	elif config.INTERFACE == SPI:

        #print "SPI mode"

		#dataOut = [0] * (len(toWrite) + 2)
		dataIn = [0] 
				
		dataOut = prep_spi_addr( 1, startAddr, toWrite )

		# actual data goes following the address bytes
		
		# dataOut.extend( toWrite ) 

        #print "Writing => ", dataOut
		
		# send out bytes, receive nothing

		(count, dataIn) = aa_spi_write( handle, array( 'B', dataOut) , array( 'B', dataIn ) )

        #print "SPI write out => ", dataOut
        #print "SPI read back => ", dataIn
	
	else:

		print "You must select a comm interface!!"
		print "in config, var interface"
		sys.exit()

#==============================================================================
# reset_FXOS8700CQ
#==============================================================================
# reset device

def reset_FXOS8700CQ():

	if INTERFACE == I2C:

		aa_i2c_write(handle, SLAVE_ADDR, AA_I2C_NO_FLAGS, array( 'B', [CTRL_REG2_ADDR, 0x40] ) )

	elif INTERFACE == SPI:

		tmpIn = [0] * 3
		(count, dataIn) = aa_spi_write( handle, array( 'B', 
            [CTRL_REG2_ADDR | 0x80, CTRL_REG2_ADDR, 0x40]) , array( 'B', tmpIn ) )

	time.sleep( 0.1 )

	while( True ):

		(count, dataIn) = read_FXOS8700CQ( CTRL_REG2_ADDR, 1 )

		if( (dataIn[0] & 0x40) == 0x00 ):
			print "Reset successful"
			break

		time.sleep(0.1)

	else:

		print "error"

#==============================================================================
# prep_spi_addr
#==============================================================================
# prepare SPI addr according to FXOS8700CQ specs

def prep_spi_addr( RWFlag, addr, readWriteBuffer ):

	addrArray = readWriteBuffer
	
	if RWFlag == 1:

		addrArray.insert(0, addr | 0x80 )
		addrArray.insert(1, addr )
		
	elif RWFlag == 0:

		addrArray.insert(0, addr & 0x7F)
		addrArray.insert(1, addr)

	else:

		print "Incorrect RWFlag"
		print "Exiting..."
		sys.exit()

	return addrArray

	
#==============================================================================
# FXOS8700CQ_display_sens_data
#==============================================================================
# read and display sensor data

def FXOS8700CQ_display_sens_data():

	(count, data_in) = read_FXOS8700CQ( 0x01, SENS_DATA_SIZE )

	#drdy = data_in.pop(0)

	acc_x_a2d = ((data_in.pop(0) << 8) | data_in.pop(0))
	#print "acc x raw data = 0x%04X" % acc_x_a2d
	acc_x_norm = int16( acc_x_a2d )
	#print "acc x norm data x 4 = 0x%04X" % acc_x_norm
	acc_x_norm = acc_x_norm >> 2
	#print "acc x norm data = 0x%04X" % acc_x_norm

	acc_y_a2d = ((data_in.pop(0) << 8) | data_in.pop(0))
	acc_y_norm = int16( acc_y_a2d )
	acc_y_norm = acc_y_norm >> 2

	acc_z_a2d = ((data_in.pop(0) << 8) | data_in.pop(0))
	acc_z_norm = int16( acc_z_a2d )
	acc_z_norm = acc_z_norm >> 2

	mag_x_a2d = ((data_in.pop(0) << 8) | data_in.pop(0))
	mag_x_norm = int16( mag_x_a2d )
	mag_x_norm = mag_x_norm

	mag_y_a2d = ((data_in.pop(0) << 8) | data_in.pop(0))
	mag_y_norm = int16( mag_y_a2d )
	mag_y_norm = mag_y_norm

	mag_z_a2d = ((data_in.pop(0) << 8) | data_in.pop(0))
	mag_z_norm = int16( mag_z_a2d )
	mag_z_norm = mag_z_norm			

	print "X MAG: %d, Y MAG: %d, Z MAG: %d, X ACC: %d, Y ACC: %d, Z ACC: %d" % \
        (mag_x_norm, mag_y_norm, mag_z_norm, acc_x_norm, acc_y_norm, acc_z_norm)

	return (mag_x_norm, mag_y_norm, mag_z_norm, acc_x_norm, acc_y_norm, acc_z_norm)

